/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.RuleBase;
import org.drools.SessionConfiguration;
import org.drools.definition.KnowledgePackage;
import org.drools.definition.process.Process;
import org.drools.definition.rule.Query;
import org.drools.definition.rule.Rule;
import org.drools.definition.type.FactType;
import org.drools.event.knowledgebase.KnowledgeBaseEventListener;
import org.drools.impl.EnvironmentFactory;
import org.drools.impl.InternalKnowledgeBase;
import org.drools.runtime.Environment;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.StatelessKnowledgeSession;
import org.jbpm.process.StatefulProcessSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessBaseImpl
implements InternalKnowledgeBase {
    private Map<String, Process> processes = new HashMap<String, Process>();
    private Map<String, KnowledgePackage> packages = new HashMap<String, KnowledgePackage>();
    private List<KnowledgeBaseEventListener> listeners = new ArrayList<KnowledgeBaseEventListener>();

    @Override
    public void addEventListener(KnowledgeBaseEventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeEventListener(KnowledgeBaseEventListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Collection<KnowledgeBaseEventListener> getKnowledgeBaseEventListeners() {
        return this.listeners;
    }

    public void addKnowledgePackage(KnowledgePackage knowledgePackage) {
        this.packages.put(knowledgePackage.getName(), knowledgePackage);
        for (Process process : knowledgePackage.getProcesses()) {
            this.processes.put(process.getId(), process);
        }
    }

    @Override
    public void addKnowledgePackages(Collection<KnowledgePackage> knowledgePackages) {
        for (KnowledgePackage knowledgePackage : knowledgePackages) {
            this.addKnowledgePackage(knowledgePackage);
        }
    }

    @Override
    public Collection<KnowledgePackage> getKnowledgePackages() {
        return this.packages.values();
    }

    @Override
    public StatefulKnowledgeSession newStatefulKnowledgeSession() {
        return this.newStatefulKnowledgeSession(new SessionConfiguration(), EnvironmentFactory.newEnvironment());
    }

    @Override
    public StatefulKnowledgeSession newStatefulKnowledgeSession(KnowledgeSessionConfiguration conf, Environment environment) {
        return new StatefulProcessSession(this, conf, environment);
    }

    @Override
    public Collection<StatefulKnowledgeSession> getStatefulKnowledgeSessions() {
        throw new UnsupportedOperationException("Getting stateful sessions not supported");
    }

    @Override
    public StatelessKnowledgeSession newStatelessKnowledgeSession() {
        throw new UnsupportedOperationException("Stateless sessions not supported");
    }

    @Override
    public StatelessKnowledgeSession newStatelessKnowledgeSession(KnowledgeSessionConfiguration conf) {
        throw new UnsupportedOperationException("Stateless sessions not supported");
    }

    @Override
    public void removeKnowledgePackage(String packageName) {
        this.packages.remove(packageName);
    }

    @Override
    public void removeRule(String packageName, String ruleName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeQuery(String packageName, String queryName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeFunction(String packageName, String ruleName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeProcess(String processId) {
        this.processes.remove(processId);
    }

    @Override
    public FactType getFactType(String packageName, String typeName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public KnowledgePackage getKnowledgePackage(String packageName) {
        return this.packages.get(packageName);
    }

    @Override
    public Process getProcess(String processId) {
        return this.processes.get(processId);
    }

    @Override
    public Collection<Process> getProcesses() {
        return this.processes.values();
    }

    @Override
    public Rule getRule(String packageName, String ruleName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Query getQuery(String packageName, String queryName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RuleBase getRuleBase() {
        return null;
    }

    @Override
    public Set<String> getEntryPointIds() {
        throw new UnsupportedOperationException("Entry points not supported");
    }
}

